import sys
import os
import internetarchive
from getpass import getpass

# --- CONFIGURATION ---
FILE_PATH = "AnthroHeart_Studio_in_a_Box.zip"
IDENTIFIER = "anthroheart-studio-in-a-box-asiab-2025" 

# HTML Formatted Description with Full Credits & Transparency
DESCRIPTION_HTML = """
<p><b>AnthroHeart Universe – Studio-in-a-Box [ASIAB] (2025)</b><br>
10 GB · 16,602 files · 147 original songs · 25 images · 23 fully-developed anthro characters · complete trilogy lore · musical · Lion King spiritual deconstruction · novels · poetry · demo reels · production bible</p>

<p><b>Created by:</b> Thomas B. Sweet (Anthro Teacher / Cio)<br>
<b>Gender/Age:</b> Male, 48<br>
<b>Location/Date:</b> Texas, USA (Dec 11, 2025 - 7:53PM CST)<br>
<b>Total Production Cost:</b> $21,815.01 USD + $3,000 USD (Fursuit)<br>
<b>Donations (PayPal):</b> healing@intentionrepeater.com</p>

<p>Released into the Public Domain (CC0) on December 7, 2025 with the words: “Take it, remix it, finish it, love it; no permission ever needed.” A whimsical, heart-forward mythic cosmos ready for animators, musicians, filmmakers, and dreamers to bring into its final form. Everything is yours forever. ♡</p>

<hr>
<b>Production Notes:</b><br>
<i>"AI art is not copyrightable and AI art is reference art to be completed by an artist."</i><br>
<i>"Flow: Once you find your sound or your design hand it to a pro so they don't have to start from scratch as they aren't a mindreader."</i>

<hr>
<b>Project Assets & Links:</b><br>
<ul>
<li><a href="https://anthroentertainment.com">Anthro Entertainment Website</a></li>
<li><a href="https://intentionrepeater.boards.net/">Community Forum</a></li>
<li><a href="https://anthroentertainment.com/anthroheartmetadata.txt">Metadata File</a></li>
<li><a href="https://anthroentertainment.com/AnthroHeart_Deck.pdf">Pitch Deck</a></li>
<li><a href="https://anthroentertainment.com/Deconstructing_Lion_King.mp3">Deconstructing Lion King (Audio)</a></li>
<li><a href="https://github.com/tsweet77">GitHub Repository</a></li>
<li><a href="https://sourceforge.net/projects/intention-repeater/">SourceForge Page</a></li>
</ul>

<b>Credits & Freelancers:</b><br>
<ul>
<li><b>Fursuit Creator:</b> <a href="https://thekareliafursuits.com/">The Karelia Fursuits</a></li>
<li><b>My Fursuit (Blue Naki):</b> <a href="https://anthroentertainment.com/images/FurryBlueNaki_Fursuit.jpg">Image</a> | <a href="https://www.youtube.com/watch?v=EGvrOhFlfBE">Video</a></li>
<li><b>AnthroHeart Icon:</b> <a href="https://anthroentertainment.com/images/AnthroHeartTrinity.png">View Image</a></li>
<li><b>Anthroness Gem:</b> <a href="https://anthroentertainment.com/images/Anthroness_Gem.png">View Image</a></li>
<li><b>Timekeeper Fox:</b> <a href="https://anthroentertainment.com/images/TimekeeperFox.jpg">View Image</a></li>
<li><b>Figure Drawing Class:</b> <a href="https://alienthink.com/">AlienThink</a></li>
<li><b>MFC Developer:</b> <a href="https://anthroentertainment.com/mfcdev.html">Details</a></li>
<li><b>Android Developer:</b> <a href="https://www.freelancer.com/u/amanraj10071998">Aman Raj</a></li>
<li><b>Book Outreach:</b> <a href="https://www.freelancer.com/u/Batairy">Batairy</a></li>
<li><b>Business Plan Writer:</b> <a href="https://www.freelancer.com/u/gregorybair">Gregory Bair</a></li>
<li><b>Website Restoration:</b> <a href="https://www.freelancer.com/u/techytrois">Techytrois</a></li>
<li><b>CUDA Developer:</b> <a href="https://www.freelancer.com/u/karteeksheri">Karteek Sheri</a></li>
<li><b>Software Engineer:</b> <a href="https://www.freelancer.com/u/Lightcanon">Lightcanon</a></li>
<li><b>Book Editor:</b> <a href="https://www.freelancer.com/u/semantix19">Semantix19</a></li>
<li><b>Graphic Design:</b> <a href="https://www.freelancer.com/u/kevinsheno">Kevin Sheno</a></li>
<li><b>Website Developer:</b> <a href="https://www.freelancer.com/u/widuIT">widuIT</a></li>
<li><b>Book Layout Fix:</b> <a href="https://www.freelancer.com/u/dfmilitello">dfmilitello</a></li>
<li><b>Professional Artist:</b> <a href="https://www.freelancer.com/u/certaintly">Certaintly</a></li>
</ul>

<b>Demos, Music & Trailers:</b><br>
<ul>
<li><a href="https://www.youtube.com/watch?v=9w8u3_ucD90">Intention Repeater Demo Reel</a></li>
<li><a href="https://www.youtube.com/watch?v=H6GEtSAQoto">Warlock Name Trailer</a></li>
<li><a href="https://www.youtube.com/watch?v=l93bUo1imXE">AnthroHeart Demo Reel</a></li>
<li><a href="https://www.youtube.com/watch?v=ZTa_9CSfGig">Dreams on the Horizon</a></li>
<li><a href="https://www.youtube.com/watch?v=vh3ooXPRtMA">Divine Heartbeat</a></li>
<li><a href="https://www.youtube.com/watch?v=ifZxYyfc4ds">Divine Anthro Disco</a></li>
<li><a href="https://www.youtube.com/watch?v=I660eTMoINY">Forever Mine</a></li>
<li><a href="https://www.youtube.com/watch?v=caT98Xxrf0E">Master Tempter's Anthem</a></li>
<li><a href="https://www.youtube.com/watch?v=icYjZVVEEVo">Wholesome</a></li>
<li><a href="https://www.youtube.com/watch?v=RScyxUMhA5o">Gentle Breeze</a></li>
<li><a href="https://www.youtube.com/watch?v=1GxmaC2pWyM">My Dog Used Up All His Pee</a></li>
<li><a href="https://www.youtube.com/watch?v=eTCy6ITGme8">Mirror Never Lies</a></li>
<li><a href="https://www.youtube.com/watch?v=ufGlBv8Z3NU">Every Mouse Has A Weenie</a></li>
<li><a href="https://www.youtube.com/watch?v=Jk_j7rz0SIg">Intention Repeater Servitor</a></li>
<li><a href="https://www.youtube.com/watch?v=EraBXl25HiU">Octave Mirror Reflect Finality Magic</a></li>
</ul>

<b>Shorts:</b><br>
<ul>
<li><a href="https://youtube.com/shorts/6Z-OZuYLqq4">Paper Towels</a></li>
<li><a href="https://youtube.com/shorts/QAHXLi8qua4">Divine Anthro Ska</a></li>
<li><a href="https://youtube.com/shorts/JkOjqEerbCU">Anthros Light Up My World</a></li>
</ul>
"""

METADATA = {
    "title": "AnthroHeart Studio in a Box (ASIAB)",
    "creator": "Thomas B. Sweet (Anthro Teacher/Cio)",
    "publisher": "Anthro Entertainment",
    "date": "2025-12-11",
    "description": DESCRIPTION_HTML,
    "licenseurl": "http://creativecommons.org/publicdomain/zero/1.0/",
    "mediatype": "data",
    "subject": [
        "furry", "anthro", "audio", "video", "pipeline", "original",
        "shaman", "celestial", "studio", "reference", "art", "music",
        "developer hell", "frontload assets"
    ],
    "language": "eng",
    "external-identifier": [
        "urn:website:anthroentertainment.com",
        "urn:youtube:channel:AnthroTeacher"
    ]
}

def get_ia_credentials():
    print("\n" + "="*60)
    print("INTERNET ARCHIVE S3 AUTHENTICATION")
    print("="*60)
    print("1. Ensure your phone is charged to verify Google Login.")
    print("2. Go here: https://archive.org/account/s3.php")
    print("3. Copy your keys below.")
    print("-" * 60 + "\n")

    access_key = input("Paste S3 ACCESS KEY: ").strip()
    secret_key = getpass("Paste S3 SECRET KEY (hidden): ").strip()
    
    if not access_key or not secret_key:
        print("Error: Keys cannot be empty.")
        sys.exit(1)
    return access_key, secret_key

def upload_file():
    if not os.path.exists(FILE_PATH):
        print(f"Error: '{FILE_PATH}' not found in this folder.")
        return

    access_key, secret_key = get_ia_credentials()

    print(f"\nStarting Upload: {METADATA['title']}")
    print(f"Author: {METADATA['creator']}")
    print(f"Date: {METADATA['date']}")
    print(f"File Count: 16,602")
    print(f"Size: ~9.47 GB")
    print("Status: Connecting to Archive.org...")
    print("="*60)

    try:
        # verbose=True triggers the progress bar
        r = internetarchive.upload(
            identifier=IDENTIFIER,
            files={FILE_PATH: FILE_PATH},
            metadata=METADATA,
            access_key=access_key,
            secret_key=secret_key,
            verbose=True, 
            verify=True
        )

        if r[0].status_code == 200:
            print("\n" + "="*60)
            print("UPLOAD COMPLETE!")
            print(f"Link: https://archive.org/details/{IDENTIFIER}")
            print("="*60)
        else:
            print(f"\nUpload ended with status code: {r[0].status_code}")

    except Exception as e:
        print(f"\nERROR: {e}")

if __name__ == "__main__":
    upload_file()